/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class BaseRsfResultDetails
implements Persistable {
    private static final String TRACE_MASKT = "XRSFRSDT";
    private static final String TRACE_MASKF = "XRSFRSDF";
    private static final String TRACE_MASKD = "XRSFRSDD";
    public static final String SAS_RC = "SAS rc";
    public static final int SEND_ERROR = 1;
    public static final int RECEIVE_ERROR = 2;
    public static final int RETAIN_ERROR = 3;
    public static final int CONNECT_ERROR = 4;
    public static final int NOT_REGISTERED = 5;
    public static final int DIAL_ERROR = 6;
    public static final int RSF_ERROR = 7;
    public static final int PATH_CANCELED = 8;
    public static final int NOT_WARRANTIED = 9;
    public static final int TOKEN_REQUEST_AUTH_ERROR = 10;
    public static final int TOKEN_REQUEST_COMMUNICATION_ERROR = 11;
    public static final int TOKEN_REQUEST_PERM_ERROR = 12;
    public static final int TOKEN_REQUEST_OWNING_SYSTEM_CREDENTIAL_ERROR = 13;
    public static final int TOKEN_REQUEST_SENDING_SYSTEM_CREDENTIAL_ERROR = 14;
    public static final int REQUEST_OWNING_SYSTEM_CREDENTIAL_ERROR = 15;
    public static final int REQUEST_SENDING_SYSTEM_CREDENTIAL_ERROR = 16;
    public static final int REQUEST_AUTH_ERROR = 17;
    public static final int REQUEST_AUTH_COMMUNICATION_ERROR = 18;
    public static final int REQUEST_AUTH_PERM_ERROR = 19;
    public static final int SAS_SERVER_ERROR = 20;
    public static final int GET_CREDENTIAL_REQUEST_ERROR = 21;
    public static final int UPDATE_CREDENTIAL_REQUEST_ERROR = 22;
    public static final int UPDATE_PASSWORD_REQUEST_ERROR = 23;
    public static final short[] eventCodes = new short[]{674, 681, 681, 679, 678, 680, 678, 676, 675, 826};
    private int reasonCode;
    private LocalizableText reasonCodeMsg;
    private RsfResultDetails resultDetails;
    private String errLogMsg = null;

    public BaseRsfResultDetails() {
        this.resultDetails = new RsfResultDetails();
    }

    public BaseRsfResultDetails(PersistentData data) {
        try {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            this.resultDetails = (RsfResultDetails)persMgr.containedFormToObject(((Persistent)data).resultDetails);
        }
        catch (PersistenceException e) {
            Trace.trace(TRACE_MASKF, "Unable to reconstruct RsfResultDetails: " + e.getMessage());
        }
        this.reasonCode = ((Persistent)data).reasonCode;
        this.reasonCodeMsg = ((Persistent)data).reasonCodeMsg;
        this.errLogMsg = ((Persistent)data).errLogMsg;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.resultDetails = PersistenceManager.getPersistenceManager().objectToContainedForm(this.resultDetails);
        result.reasonCode = this.reasonCode;
        result.reasonCodeMsg = this.reasonCodeMsg;
        result.errLogMsg = this.errLogMsg;
        return result;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(int reasonCode) {
        this.reasonCode = reasonCode;
    }

    public String getErrLogMsg() {
        return this.errLogMsg;
    }

    public void setReasonCodeMessage(LocalizableText msg) {
        this.reasonCodeMsg = msg;
    }

    public LocalizableText getReasonCodeMessage() {
        return this.reasonCodeMsg;
    }

    public void setErrLogMsg(String logMsg) {
        this.errLogMsg = logMsg;
    }

    public RsfResultDetails getRsfResultDetails() {
        return this.resultDetails;
    }

    public void setRsfResultDetails(RsfResultDetails resultDetails) {
        this.resultDetails = resultDetails;
    }

    private static class Persistent
    implements PersistentData {
        Object resultDetails;
        String errLogMsg;
        int reasonCode;
        LocalizableText reasonCodeMsg;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

